import os


def delete_png_files(folder_path):
    """
    Delete all .png files in the specified directory and its subdirectories.

    Args:
        folder_path (str): Path to the directory to be cleaned.
    """
    if not os.path.exists(folder_path):
        print(f"Directory does not exist: {folder_path}")
        return

    for root, _, files in os.walk(folder_path):
        for file in files:
            if file.lower().endswith(".png"):
                file_path = os.path.join(root, file)
                try:
                    os.remove(file_path)
                    print(f"Deleted: {file_path}")
                except Exception as e:
                    print(f"Error deleting {file_path}: {e}")


def process_aag_files(folder_path):
    """
    Process all .aag files in the specified directory by removing the last element
    from each line containing exactly 4 space-separated elements.

    Args:
        folder_path (str): Path to the directory containing .aag files.
    """
    if not os.path.exists(folder_path):
        print(f"Directory does not exist: {folder_path}")
        return

    for file_name in os.listdir(folder_path):
        if file_name.lower().endswith(".aag"):
            file_path = os.path.join(folder_path, file_name)
            print(f"Processing: {file_path}")

            with open(file_path, 'r') as file:
                lines = file.readlines()

            modified_lines = []
            for line in lines:
                parts = line.strip().split()
                if len(parts) == 4:
                    modified_line = " ".join(parts[:-1]) + "\n"
                    modified_lines.append(modified_line)
                else:
                    modified_lines.append(line)

            with open(file_path, 'w') as file:
                file.writelines(modified_lines)

            print(f"Completed: {file_path}")


if __name__ == "__main__":
    folder_path = 'generated_aigs/in20_out20_tt20/and160/aag'
    process_aag_files(folder_path)
